(*  This simple application will allow you to easily test the LockManager
    component.

   Run this program with the command line LOCKTEST Wapiti138 to create or reset
   the signature file. Wapiti 138 is the command line password that resets the
   signature file.

   Within the Delphi IDE you can specify the password (Wapiti 138) using the
   RUN/Parameters... menu item. Don't forget to remove the password from that
   same menu item on the next run or the application will again reset the
   signature file !

   The application is locked to the drive it is installed
   and is configured for a maximum of 5 trial runs. You can reset the trial
   period by using the command line defined above. Try to copy the application
   to another drive or computer to check how good it detects unauthorized copy.
   If you copy the application to another drive, you must use the
   command line decribed above to reset the signature file for the new drive.

   Read the LockMAN.wri file for additional information.

   I encourage you to play with the properties to test all the functionality
   provided by the component.

   Here's how to contact us:
    http://ourworld.compuserve.com/homepages/Big_Alll
*)

unit Test;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Lockman, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    LockMan: TLockManager;
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    procedure LockManTerminate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure LockManPasswordFound(Sender: TObject;
      var Terminate: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.LockManTerminate(Sender: TObject);
begin
(* Works with the Registered version only *)
     MessageDlg('To reset the trial period use the command line parameter Wapiti138.'+
                 ' But remember that this is a secret !',mtInformation,[mbOK],0);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    LockMan.Execute;
    Label2.Caption:=IntToStr(LockMan.NumberofRuns)
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     Close;
end;

procedure TForm1.LockManPasswordFound(Sender: TObject;
  var Terminate: Boolean);
begin
(* Works with the Registered version only *)
     MessageDlg('Yes! you have found the secret password!!!',mtInformation,[mbOK],0);
     Terminate:=False;
end;

end.
